<?php

namespace App\Models\GestionSiteBusiness;

use Illuminate\Database\Eloquent\Model;

class Guichet extends Model 
{

    protected $table = 'guichets';
    public $timestamps = true;
    protected $fillable = array('site_id', 'libelle', 'statut');

    public function site()
    {
        return $this->belongsTo('App\Models\GestionSiteBusiness\Site');
    }

    public function comptes()
    {
        return $this->hasMany('App\Models\GestionTransaction\Compte', 'guichet_id');
    }

    public function affectations()
    {
        return $this->hasMany('App\Models\GestionSiteBusiness\AffectationAgent', 'guichet_id');
    }

}